class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Yukon News'
    oldest_article = 7
    max_articles_per_feed = 100
    
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                 

    remove_tags_before = dict(id='content')
    remove_tags = [dict(name='div', attrs={'class':['story_image','block','block special_report_sidebar','block collapsable']}),
                   dict(name='div', attrs={'id':['comments','sidebar','footer','story_details']}),
                   dict(name='ul', attrs={'class':['']}),
                   dict(name='ul', attrs={'id':['']}),
                   dict(name='img'),]

    feeds          = [(u'News', u'http://yukon-news.com/xml/rss/'), 
                          (u'Opinions', u'http://yukon-news.com/xml/rss_opinions/')]
                    

    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		